/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.DataLogParameter;
import DE.siemens.ad.logo.model.IOParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DataLogPanel
extends AbstractProtectionPanel {
    private JTable fTable;
    private WiringDiagram fWD;
    JButton insertParameterItemButton;
    JButton removeParameterItemButton;
    BorderJPanel blockListPanel;
    JList blockJList;
    BorderJPanel parameterListPanel;
    JList parameterItemJList;
    List<ItemInfo> parameterItemList = new ArrayList<ItemInfo>();
    Vector concreteParameterItems;

    public DataLogPanel() {
    }

    public DataLogPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.addParameterPane(this.getParameterPanel());
        this.initListeners();
    }

    private JPanel getParameterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel operPanel = new JPanel();
        operPanel.setLayout(new BoxLayout(operPanel, 0));
        operPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        operPanel.add(Box.createHorizontalStrut(10));
        this.insertParameterItemButton = new JButton(Language.getString("dialog.parameter.editudf.addBtn", "Add"));
        operPanel.add(this.insertParameterItemButton);
        operPanel.add(Box.createHorizontalStrut(20));
        this.removeParameterItemButton = new JButton(Language.getString("dialog.parameter.editudf.removeBtn", "Remove"));
        this.insertParameterItemButton.setEnabled(false);
        operPanel.add(this.removeParameterItemButton);
        this.fTable = new JTable(new DataLogTableModel());
        this.fTable.setRowHeight(20);
        JScrollPane jsp = new JScrollPane(this.fTable);
        jsp.setPreferredSize(new Dimension(300, 230));
        jsp.setBorder(BorderFactory.createTitledBorder(Language.getString("panel.dataLog.datalogItems", "Datalog Items")));
        this.fTable.setShowGrid(true);
        this.fTable.setSelectionMode(2);
        this.fTable.getColumnModel().getColumn(0).setCellRenderer(new BlockTableCellRender());
        this.fTable.getColumnModel().getColumn(1).setCellRenderer(new ParameterTableCellRender());
        panel.add((Component)jsp, "North");
        panel.add((Component)operPanel, "Center");
        JPanel allParamListPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 20.0;
        gbc.insets.bottom = 3;
        allParamListPanel.add((Component)this.getBlockListPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 20.0;
        gbc.insets.bottom = 3;
        allParamListPanel.add((Component)this.getParameterListPanel(), gbc);
        panel.add((Component)allParamListPanel, "South");
        return panel;
    }

    private JPanel getParameterListPanel() {
        this.parameterListPanel = new BorderJPanel(new BorderLayout());
        this.parameterListPanel.setTitle(Language.getString("dialog.parameter.editudf.blockParameterBorder", "Parameter"));
        this.parameterItemJList = new JList();
        ParameterItemListCellRenderer parameterItemListCellRenderer = new ParameterItemListCellRenderer();
        parameterItemListCellRenderer.setHorizontalTextPosition(10);
        this.parameterItemJList.setCellRenderer(parameterItemListCellRenderer);
        this.parameterItemJList.setSelectionMode(0);
        this.parameterListPanel.add((Component)new JScrollPane(this.parameterItemJList), "Center");
        this.parameterListPanel.setPreferredSize(new Dimension(300, 170));
        return this.parameterListPanel;
    }

    private JPanel getBlockListPanel() {
        this.blockListPanel = new BorderJPanel(new BorderLayout());
        this.blockListPanel.setTitle(Language.getString("dialog.parameter.editudf.blockBorder", "Block"));
        this.blockJList = new JList();
        this.blockJList.setSelectionMode(0);
        this.blockJList.setCellRenderer(new DataLogCellRender(true));
        this.blockListPanel.add(new JScrollPane(this.blockJList));
        this.blockListPanel.setPreferredSize(new Dimension(300, 170));
        return this.blockListPanel;
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        DataLogParameter dataLogParam = (DataLogParameter)this.getParameterReference();
        this.fWD = dataLogParam.getBlock().getWiringDiagram();
        this.parameterItemList.clear();
        ParameterItemList itemListToLoad = dataLogParam.getParameterItemList();
        if (itemListToLoad != null) {
            for (Object item : itemListToLoad) {
                ParameterItem parameterItem = (ParameterItem)item;
                this.parameterItemList.add(new ItemInfo(parameterItem.getParameter().getBlock(), parameterItem));
            }
        }
        this.blockJList.setListData(this.getBlocksForReference());
    }

    public Block[] getBlocksForReference() {
        Enumeration blockEnum = this.fWD.getBlocks().elements();
        Vector<Block> blocks = new Vector<Block>();
        this.addConstants(blocks);
        while (blockEnum.hasMoreElements()) {
            Block block = (Block)blockEnum.nextElement();
            BlockParameter blockParameter = block.getParameter();
            if (blockParameter == null || blockParameter.getParameterItems().getPublicParameterItemList().isEmpty()) continue;
            blocks.addElement(block);
        }
        Object[] aObjects = blocks.toArray();
        Block[] aBlocks = new Block[aObjects.length];
        for (int i = 0; i < aBlocks.length; ++i) {
            aBlocks[i] = (Block)aObjects[i];
        }
        Block.sortForBlockNumber(aBlocks);
        return aBlocks;
    }

    private void addConstants(Vector blocks) {
        ConstantBlock block;
        int i;
        for (i = 1; i <= this.fWD.getHardware().getMaxResource(6); i += 8) {
            block = new InputBlock();
            block.setNumber(i);
            blocks.add(block);
        }
        for (i = 1; i <= this.fWD.getHardware().getMaxResource(11); ++i) {
            block = new AnalogInputBlock();
            block.setNumber(i);
            blocks.add(block);
        }
        for (i = 1; i <= this.fWD.getHardware().getMaxResource(7); i += 8) {
            block = new OutputBlock();
            block.setNumber(i);
            blocks.add(block);
        }
        for (i = 1; i <= this.fWD.getHardware().getMaxResource(13); ++i) {
            block = new AnalogOutputBlock();
            block.setNumber(i);
            blocks.add(block);
        }
        for (i = 1; i <= this.fWD.getHardware().getMaxResource(10); i += 8) {
            block = new MarkerBlock();
            block.setNumber(i);
            blocks.add(block);
        }
        for (i = 1; i <= this.fWD.getHardware().getMaxResource(16); ++i) {
            block = new AnalogMarkerBlock();
            block.setNumber(i);
            blocks.add(block);
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        DataLogParameter dataLogParam = (DataLogParameter)this.getParameterReference();
        ParameterItemList paraList = dataLogParam.getParameterItemList();
        paraList.clear();
        for (ItemInfo info : this.parameterItemList) {
            String paraItemIdentifier = info.item.getIdentifier();
            if (this.isConstant(info.block)) {
                paraList.add(info.item);
                continue;
            }
            if (info.block == null || paraItemIdentifier == null) continue;
            ParameterItem paraItem = info.block.getParameter().getParameterItem(paraItemIdentifier);
            paraList.add(paraItem);
        }
    }

    public boolean checkChanged() {
        return true;
    }

    public boolean checkFieldContents() {
        return super.checkFieldContents();
    }

    private Icon getParamIcon(ParameterItem parameterItem) {
        ImageIcon icon = null;
        if (parameterItem.getParameterValueType() == 1 && !parameterItem.isEditable()) {
            icon = Global.getIcon("Refresh.gif");
        }
        if (parameterItem.getParameterValueType() == 1 && parameterItem.isEditable()) {
            icon = Global.getIcon("RefreshEditable.gif");
        }
        if (parameterItem.getParameterValueType() != 1 && parameterItem.isEditable()) {
            icon = Global.getIcon("Editable.gif");
        }
        if (parameterItem.getParameterValueType() == 2) {
            icon = Global.getIcon("Refresh.gif");
        }
        return icon;
    }

    private void initListeners() {
        this.blockJList.addListSelectionListener(new BlockListSelectionListener());
        this.parameterItemJList.addListSelectionListener(new ParameterItemSelectionListener());
        MouseAdapter doubleClickListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && (DataLogPanel.this.parameterItemList == null || DataLogPanel.this.parameterItemList.size() < DataLogPanel.this.fWD.getHardware().getIntProperty("maximumDatalogRecords"))) {
                    DataLogPanel.this.addParaItemOrConstant();
                }
            }
        };
        this.parameterItemJList.addMouseListener(doubleClickListener);
        this.insertParameterItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataLogPanel.this.addParaItemOrConstant();
            }
        });
        this.removeParameterItemButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DataLogPanel.this.fTable.isEditing()) {
                    DataLogPanel.this.fTable.getCellEditor().cancelCellEditing();
                }
                if (DataLogPanel.this.parameterItemList == null || DataLogPanel.this.parameterItemList.size() == 0) {
                    return;
                }
                int[] deleted = DataLogPanel.this.fTable.getSelectedRows();
                for (int i = deleted.length - 1; i >= 0 && deleted[i] < DataLogPanel.this.parameterItemList.size(); --i) {
                    DataLogPanel.this.parameterItemList.remove(deleted[i]);
                }
                DataLogPanel.this.fTable.repaint();
                DataLogPanel.this.fillParameterList();
            }
        });
    }

    protected void fillParameterList() {
        block7: {
            Block block;
            block4: {
                block = (Block)this.blockJList.getSelectedValue();
                if (block == null) {
                    return;
                }
                this.concreteParameterItems = new Vector();
                if (this.isConstant(block)) break block4;
                this.insertParameterItemButton.setEnabled(false);
                BlockParameter blockParameter = block.getParameter();
                for (ParameterItem parameterItem : blockParameter.getParameterItems().getPublicParameterItemList().instance(blockParameter)) {
                    boolean insertFlg;
                    block6: {
                        block5: {
                            insertFlg = true;
                            if (this.parameterItemList.size() != 0) break block5;
                            if (parameterItem.getParameterValueType() == 1) break block6;
                            insertFlg = false;
                            break block6;
                        }
                        for (int i = 0; i < this.parameterItemList.size(); ++i) {
                            if (!parameterItem.equals(this.parameterItemList.get((int)i).item) && parameterItem.getParameterValueType() == 1) continue;
                            insertFlg = false;
                            break;
                        }
                    }
                    if (!insertFlg) continue;
                    this.concreteParameterItems.add(parameterItem);
                }
                break block7;
            }
            boolean contained = false;
            for (int i = 0; i < this.parameterItemList.size(); ++i) {
                if (!block.getLocalizedName(true).equals(this.parameterItemList.get((int)i).block.getLocalizedName(true))) continue;
                contained = true;
                break;
            }
            this.insertParameterItemButton.setEnabled(!contained);
        }
        this.parameterItemJList.setListData(this.concreteParameterItems);
    }

    private boolean isConstant(Block block) {
        int blockType = block.getNumberType();
        return blockType == 6 || blockType == 11 || blockType == 7 || blockType == 13 || blockType == 10 || blockType == 16;
    }

    protected void addParaItemOrConstant() {
        if (this.parameterItemList != null && this.parameterItemList.size() >= this.fWD.getHardware().getIntProperty("maximumDatalogRecords")) {
            new LogoError(null, "panel.dataLogMaxRecordsWarning", "The maximu number of items to be logged has reached. To add more items, you must remove some other items from the list.", 2, 0).display();
            return;
        }
        ParameterItem parameterItem = null;
        Block selectedBlock = (Block)this.blockJList.getSelectedValue();
        if (this.isConstant(selectedBlock)) {
            IOParameter blockPara = new IOParameter(selectedBlock);
            ParameterItem paraItem = new ParameterItem(IOParameter.class, selectedBlock.getName(), 0, "", "ItemValue", 0, false, false, 0, false, 0, false);
            paraItem.setParameter(blockPara);
            this.parameterItemList.add(new ItemInfo(selectedBlock, paraItem));
            this.fTable.updateUI();
        } else {
            if (this.parameterItemJList.getSelectedValue() != null) {
                parameterItem = (ParameterItem)this.parameterItemJList.getSelectedValue();
            }
            if (parameterItem == null) {
                return;
            }
            this.parameterItemList.add(new ItemInfo(parameterItem.getParameter().getBlock(), parameterItem));
            this.fTable.updateUI();
        }
        if (this.parameterItemList != null && this.parameterItemList.size() >= this.fWD.getHardware().getIntProperty("maximumDatalogRecords")) {
            this.insertParameterItemButton.setEnabled(false);
        }
        this.fillParameterList();
    }

    public class ItemInfo {
        Block block;
        ParameterItem item;

        public ItemInfo() {
        }

        public ItemInfo(Block block, ParameterItem item) {
            this.block = block;
            this.item = item;
        }
    }

    private class ParameterTableCellRender
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ParameterItem item = (ParameterItem)value;
            Block block = item.getParameter().getBlock();
            ParameterItem blockParameterItem = block.getParameter().getParameterItem(item.getIdentifier());
            String text = "";
            if (blockParameterItem != null) {
                text = blockParameterItem.getLocalisedName();
            }
            this.setText(text);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setIcon(DataLogPanel.this.getParamIcon((ParameterItem)value));
            this.setHorizontalTextPosition(2);
            return this;
        }
    }

    private class BlockTableCellRender
    extends DefaultTableCellRenderer {
        protected float scale = 0.5f;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Block block = (Block)value;
            int blockType = block.getNumberType();
            String text = null;
            text = blockType == 6 || blockType == 7 || blockType == 10 ? this.getTextForDatalogDisplay(block) : block.getLocalizedName(true);
            this.setText(text);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setIcon(this.scaleIcon(Global.getIcon(((Block)value).getIconName())));
            return this;
        }

        private String getTextForDatalogDisplay(Block block) {
            int blockNrType = block.getNumberType();
            int blockNr = block.getNumber();
            String retStr = null;
            if (blockNrType == 6) {
                retStr = "I" + blockNr + "-I" + (blockNr + 7);
            } else if (blockNrType == 7) {
                retStr = "Q" + blockNr + "-Q" + (blockNr + 7);
            } else if (blockNrType == 10) {
                retStr = "M" + blockNr + "-M" + (blockNr + 7);
                if (blockNr == 25) {
                    retStr = "M25-M27";
                }
            }
            return retStr;
        }

        protected Icon scaleIcon(ImageIcon orgIcon) {
            float scale = this.getScale();
            if (scale == 0.5f) {
                return new ImageIcon(orgIcon.getImage().getScaledInstance((int)((float)orgIcon.getIconWidth() * scale), (int)((float)orgIcon.getIconHeight() * scale), scale > 1.0f ? 2 : 4));
            }
            return orgIcon;
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }
    }

    class DataLogTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{Language.getString("dialog.parameter.editudf.paramColBlock", "Block"), Language.getString("dialog.parameter.editudf.paramColParameter", "Parameter")};

        DataLogTableModel() {
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return DataLogPanel.this.parameterItemList.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            ItemInfo info = DataLogPanel.this.parameterItemList.get(rowIndex);
            if (info.item == null) {
                return "";
            }
            if (columnIndex == 0) {
                return info.block;
            }
            return info.item;
        }
    }

    private class ParameterItemListCellRenderer
    extends DefaultListCellRenderer {
        private ParameterItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            ParameterItem parameterItem = (ParameterItem)value;
            this.setText(parameterItem.getLocalisedName());
            this.setIcon(DataLogPanel.this.getParamIcon(parameterItem));
            return this;
        }
    }

    protected class ParameterItemSelectionListener
    implements ListSelectionListener {
        protected ParameterItemSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            DataLogPanel.this.insertParameterItemButton.setEnabled((DataLogPanel.this.parameterItemList == null || DataLogPanel.this.parameterItemList.size() < DataLogPanel.this.fWD.getHardware().getIntProperty("maximumDatalogRecords")) && ((JList)e.getSource()).getSelectedValue() != null);
        }
    }

    protected class BlockListSelectionListener
    implements ListSelectionListener {
        protected BlockListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (DataLogPanel.this.blockJList.getSelectedIndex() != -1) {
                DataLogPanel.this.fillParameterList();
            }
        }
    }

    private static class DataLogCellRender
    extends BlockListCellRenderer
    implements TableCellRenderer {
        public DataLogCellRender(boolean b) {
            super(b);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            this.handleLableByValue(value);
            return this;
        }

        protected String getValueText(Block block, Object value) {
            int blockNrType = block.getNumberType();
            int blockNr = block.getNumber();
            if (blockNrType == 6) {
                return "I" + blockNr + "-I" + (blockNr + 7);
            }
            if (blockNrType == 7) {
                return "Q" + blockNr + "-Q" + (blockNr + 7);
            }
            if (blockNrType == 10) {
                String result = "M" + blockNr + "-M" + (blockNr + 7);
                if (blockNr == 25) {
                    result = "M25-M27";
                }
                return result;
            }
            return super.getValueText(block, value);
        }
    }
}

